%-------------------------------------------------------------------------------
% Project Name:   Image Filter Arrays
% File Name:      CreateUniformSensor.m
% Authors:        JF Heukelman   005538085
%                 J Peterson     005567016
%                 Professor Brian Wandell
%                 Professor Joyce Farrell
% Class:          PSYCH221
% File Version:   1
% Description:    This file defines a custom image sensor array
%-------------------------------------------------------------------------------

% Separate the filters linearly across the spectrum
cPos = linspace(minWavelength,maxWavelength,numSensors);
width = ones(size(cPos))*(cPos(2)-cPos(1))/2;

% Define a couple of fixed 5-color sensors for debug
%{
numSensors = 5;
width = [29.5833   29.5833   14.5833   14.5833   37.0833];
cPos = [400.0000  425.0000  478.0000  628.0000  678.0000];
%}


% Build a default sensor
sensor = sensorCreate;
wave = sceneGet(scene,'wave');

cfType = 'gaussian'; 
filterSpectra = sensorColorFilter(cfType, wave, cPos, width);

% Use some subset of these names
allNames = {'b1','g1','r1','x1','i1','z1','i2'};
filterNames = cell(1,numSensors);
for ii=1:numSensors, 
   filterNames{ii} = allNames{ii};
end

% Show the wavelength partitioning
% figure(1); plot(wave,filterSpectra)

sensor = sensorSet(sensor,'wave',wave);
sensor = sensorSet(sensor,'filterSpectra',filterSpectra);
sensor = sensorSet(sensor,'filterNames',filterNames);


switch(numSensors),
   case{3}
      p = [3,2;2,1];
   case{4}
      p = [1,2;3,4];
   case{5}
      %p = [1,2,3; 2,3,4; 3,4,5];
      p = [2,2,2; 1,4,1; 3,3,5];
   case{6}
      %p = [1,3,4; 5,4,2; 4,3,6];
      %p = [1,4,1; 2,2,6; 3,3,5];
      p = [6,5,3;1,4,1;2,2,2];
   case{7}
      %p = [1,3,4; 2,4,6; 4,5,7];
      %p = [1,6,1; 7,3,5; 2,2,4];
      p = [1,4,1;2,5,2;3,6,7];
   otherwise
      p = [];
      while length(unique(p(:))) ~= numSensors
          p = round(rand(3,3)*(numSensors-1) + 1);
      end
      fprintf('Spatial pattern\n')
      p
end

sensor = sensorSet(sensor,'pattern',p);

%if (showISET == TRUE),
%   sensorShowCFA(sensor);
%end
sensorColorArray = zeros([size(p),3]);
for ii = 1:size(p,1),
   for jj = 1:size(p,2),
      [r,g,b] = WavelengthToRGB(cPos(p(ii,jj)));
      sensorColorArray(ii,jj,1) = r;
      sensorColorArray(ii,jj,2) = g;
      sensorColorArray(ii,jj,3) = b;
   end
end
figure();
sensorColorArray = imresize(sensorColorArray, [60,60], 'nearest');
imagesc(sensorColorArray, [0,1]);
axis image


% Match the sensor size to the scene FOV
sensor = sensorSetSizeToFOV(sensor,sceneGet(scene,'fov'));

% Compute the image and bring it up.
sensor = sensorCompute(sensor,oi);
vcAddAndSelectObject(sensor);

if (showISET == TRUE),
   sensorImageWindow;
end

% End of File
